
//*****************************************************************************
//
// \file uart_drv.c
//
// \brief 
//
// Copyright (c) 2013-2014 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
//*****************************************************************************
#include <msp430.h>
#include <stdbool.h>
#include <stdint.h>
#include "uart_drv.h"

// Defines
#define LSB_FIRST             (0x00)
#define NO_PARITY             (0x00)
#define EIGHT_DATA_BITS       (0x00)
#define ONE_STOP_BIT          (0x00)

// Types

// Global Variables
bool Sync_Byte_Received = false;

// Constants

// Prototype Declarations

// Local Function Declarations
//****************************************************************************
// Name: UART_Init
// Details:
//****************************************************************************
void UART_Init(UART_PORT_SELECT iPort)
{
    if (USCIA_0 == iPort)
    {
    	// USCIA - P1.1=RXD, P1.2=TXD
    	P1SEL  |= BIT1 + BIT2;
    	P1SEL2 |= BIT1 + BIT2;
		P1REN  |= BIT1;
    }
    else
    {
    }

    // Configure UCA0CTL0
    UCA0CTL0 = LSB_FIRST | NO_PARITY | EIGHT_DATA_BITS | ONE_STOP_BIT | UCMODE_3;

    // Configure UCA0CTL1, use SMCLK and DORM mode
    UCA0CTL1 |= UCSSEL_2 + UCDORM;

    UCA0BR0  = (uint8_t)(BAUD_19200);
    UCA0BR1  = (uint8_t)(BAUD_19200 >> 8);
    UCA0MCTL |= UCBRS_19200;

    UCA0ABCTL = UCABDEN;

    // Set the UART Interrupt priority
    Enable_UART_BF_Interrupt(iPort);
}

//****************************************************************************
// Name: UART_Rx
// Details:
//****************************************************************************
uint8_t UART_Rx(UART_PORT_SELECT iPort)
{
 uint8_t Value;

  Value = UCA0RXBUF;

  return (Value);
}

//****************************************************************************
// Name: UART_Tx
// Details:
//****************************************************************************
void UART_Tx(UART_PORT_SELECT iPort, uint8_t Data)
{
	UCA0TXBUF = Data;

	// Wait for transmit operation
	while ( ( UCA0STAT & UCBUSY ) == UCBUSY);
}

// USCIAB0RX interrupt service routine
#pragma vector=USCIAB0RX_VECTOR
__interrupt void USCI0RX_ISR(void)
{
  uint8_t sync_rx_byte;

   if (SBF_Received)
   {
	   sync_rx_byte = UART_Rx(USCIA_0);
	   // Receive Message
	   Rx_ISR(USCIA_0,sync_rx_byte);
   }
   else
   {
	   SBF_Received = true;
   
	   // Clear BF flag and disable Interrupt
	   Clear_UART_BF_Flag(USCIA_0);
	   Disable_UART_BF_RX_DormantMode(USCIA_0);
   }
}
